;*****************************************************************************************************************
;Source File Name:
;		oscres.jss
;Author's Name:
;		Ben Key 
;Description:
;	JFW Script file for oscarui.dll, the dll file for the AOL Instant Messenger Edit Preferences 
;	dialog.
;Included Header Files:
;	hjconst.jsh
;		default HJ constants 
;	hjglobal.jsh
;		default HJ global variables
;	aim.jsh
;		Global header file for the entire AIM project.  Contains all constants and globals used
;		in the AIM project.
;	aim.jsm
;		Global Message file for the entire AIM project.
;
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 07/01/1999			Ben Key
;	Occarui.jss added to AIM project.
; 07/02/1999			Ben Key
;	Finished the task of making all the controls on all the various pages speak properly
;*****************************************************************************************************************

include "hjconst.jsh"			; default HJ constants 
include "hjglobal.jsh"		; default HJ global variables
Include "AIM.jsh"
Include "AIM.jsm"

Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var  int TheTypeCode, string RealName, String strTest
let theTypeCode = nSubTypeCode
if (TheTypeCode == WT_BUTTON) then ;#1
	Say (kcmsg001, ot_help) ;"This is the"
	Say (GetWindowName (GetCurrentWindow ()), ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_COMBOBOX) then ;#2
  Say (kcmsg004, ot_help) ;"This is a Combo box"
  Say (kcmsg005a, ot_help) ;"type in a value or use the arrow keys to move between the items"
  Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
  Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
  Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_EDIT) then ;#3
  Say (kcmsg007, ot_help) ;"This is an edit field in which you can type information"
  Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
  Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  Return
EndIf
if (TheTypeCode == WT_LISTBOX) then ;#4
  if (IsSelectScriptDlg()) then
    Say (kcmsg009, ot_help) ;"This is an execute item list box"
    Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (kcmsg145, ot_help) ;"Use the space bar to toggle the selected item"
    Say (kcmsg146, ot_help) ;"Use the enter key to close this dialog"
  elif (IsSelectItemDlg()) then
    Say (kcmsg147, ot_help) ;"this is a select item list box"
    Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (kcmsg148, ot_help) ;"Use enter to choose the item and exit the dialog"
    Say (kcmsg149, ot_help) ;"Use escape to cancel the dialog"
  else
    Say (kcmsg016, ot_help) ;"This is a list box"
    Let strTest = GetWindowName (GetRealWindow (GetFocus ()))
    Say (kcmsg017, ot_help) ;"Use the arrow keys or the first letter to move to an item"
    Say (kcmsg018, ot_help) ;"Use Enter to select it"
    Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
  endif
  Return
EndIf
if (TheTypeCode == WT_SCROLLBAR) ||
(TheTypeCode ==WT_LEFTRIGHTSCROLLBAR)
 then ;#5
	Say (kcmsg019, ot_help) ;"This is a scroll bar"
	Say (kcmsg020, ot_help) ;"Use the right arrow down arrow or page down keys to increase the value"
	Say (kcmsg021, ot_help) ;"Use the left arrow up arrow or page up keys to decrease the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
elif  (TheTypeCode ==WT_UPDOWNSCROLLBAR) Then
	Say (kcmsg142, ot_help) ;"This is an Up Down scroll bar"
	Say (kcmsg143, ot_help) ;"Use the right arrow down arrow or page down keys to decrease the value"
	Say (kcmsg144, ot_help) ;"Use the left arrow up arrow or page up keys to increase the value"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
EndIf
if (TheTypeCode == WT_STATIC) then ;#6
	Say (kcmsg022, ot_help) ;"This is static text for information only"
	Say (kcmsg023, ot_help) ;"Use the reading keys to read the text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_TOOLBAR) then ;#7
	Say (kcmsg024, ot_help) ;"this is a tool bar"
	Say (kcmsg025, ot_help) ;"it contains various controls and graphics"
	Say (kcmsg026, ot_help) ;"it is generally accessed with the mouse by point and click"
	Say (kcmsg027, ot_help) ;"most tool bar items can also be found within menus"
	Return
endif
if (TheTypeCode == WT_STATUSBAR) then ;#8
	Say (kcmsg028, ot_help) ;"This is an application status bar"
	Say (kcmsg029, ot_help) ;"It provides a variety of information depending on the focus"
	Say (kcmsg030, ot_help) ;"by default jaws will read this with insert plus page down"
	Return
endif
if (TheTypeCode == WT_HEADERBAR) then ;#9
	Say (kcmsg031, ot_help) ;"This is a header bar"
	Say (kcmsg032, ot_help) ;"it contains titles for various columns below the header bar"
	Say (kcmsg033, ot_help) ;"clicking on a particular title"
	Say (kcmsg034, ot_help) ;"will generally sort the list based on the information in that column"
	Return
endif
if (TheTypeCode == WT_SPINBOX) then ;#12
	Say (kcmsg035, ot_help) ;"This is a spin box"
	Say (kcmsg036, ot_help) ;"you can edit this control manually or"
	Say (kcmsg037, ot_help) ;"arrow up or down arrow to increase or decrease its value"
	Return
endif
;WT_MENU = 13,
if (TheTypeCode == WT_MENU) then
	Say (kcmsg038, ot_help) ;"This is a menu"
	Say (kcmsg039, ot_help) ;"Use the arrow keys to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_DESKTOP = 14,
if (TheTypeCode == WT_DESKTOP) then
	Say (kcmsg041, ot_help) ;"This is the desktop"
	Say (kcmsg042, ot_help) ;"This is the area underlying all application windows"
	Return
EndIf
;WT_ICONTITLE = 16,
if (TheTypeCode == WT_ICONTITLE) then
	Say (kcmsg043, ot_help) ;"This is an Icon Title resulting from a minimized group or application"
	If (IsJAWSCursor ()) then
		Say (kcmsg044, ot_help) ;"Press the left mouse button to activate"
		Return
	EndIf
	If (IsPCCursor ()) then
		Say (kcmsg045, ot_help) ;"Press enter to activate"
		Return
	EndIf
EndIf
;WT_MDICLIENT = 17,
if (TheTypeCode == WT_MDICLIENT) then
	Say (kcmsg046, ot_help) ;"This is an multiple document interface client window"
	Say (kcmsg047, ot_help) ;"This is the space underlying documents in an m d i environment"
	Return
EndIf
;WT_DIALOG = 18,
if (TheTypeCode == WT_DIALOG) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg049, ot_help) ;"Use the tab keys to move between the fields"
	Return
EndIf
;WT_RADIOBUTTON = 19,
if (TheTypeCode == WT_RADIOBUTTON) then
	Say (kcmsg050, ot_help) ;"This is one of a group of radio buttons"
	Say (kcmsg051, ot_help) ;"only one can be checked at a time"
	Say (kcmsg052, ot_help) ;"Use the up and down arrow keys to move the check mark"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_CHECKBOX = 20,
if (TheTypeCode == WT_CHECKBOX) then
	Say (kcmsg053, ot_help) ;"This is a check box"
	Say (kcmsg054, ot_help) ;"Use the space bar to toggle the check mark on and off"
	Say (kcmsg055, ot_help) ;"Read current line or word to read it"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_GROUPBOX = 21,
if (TheTypeCode == WT_GROUPBOX) then
	Say (kcmsg056, ot_help) ;"This is a groupbox"
	If (GetVerbosity () == 0) then
		Say (kcmsg057, ot_help) ;"It is used to group items that are related"
		Say (kcmsg058, ot_help) ;"such as radio buttons"
	EndIf
	Say (kcmsg059, ot_help) ;"use the pc cursor to move between the controls"
	Return
EndIf
;WT_SDM = 23,
if (TheTypeCode == WT_SDM) then
	Say (kcmsg048, ot_help) ;"This is a dialog box"
	Say (kcmsg060, ot_help) ;"use tab and shift tab to move between the controls"
	Say (kcmsg061, ot_help) ;"select ok to accept the changes or cancel to ignore the changes"
	Return
EndIf
;WT_GENERALPICTURE= 25,
if (TheTypeCode == WT_GENERALPICTURE) then
	Say (kcmsg062, ot_help) ;"This is a General picture"
	Say (kcmsg063, ot_help) ;" functions or designs specific to the application"
	Return
EndIf
;WT_HOTKEY = 28,
if (TheTypeCode == WT_HOTKEY) then
	Say (kcmsg064, ot_help) ;"This is a hot key or short cut key edit control"
	Say (kcmsg065, ot_help) ;"be careful or you may define a short cut key by pressing any letter key"
	Say (kcmsg066, ot_help) ;"or most combinations of letter key and alt control or shift"
	Say (kcmsg067, ot_help) ;"use the tab key to move to the next control"
	Return
EndIf
;WT_TABCONTROL=29,
if (TheTypeCode == WT_TABCONTROL) then
	Say (kcmsg068, ot_help) ;"This is a tab control found in multi page dialog boxes"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg070, ot_help) ;"use the tab key to move between the controls in the dialog box"
	Return
EndIf
;WT_LISTVIEW=30,
if (TheTypeCode == WT_LISTVIEW) then
	let RealName = GetWindowName (GetRealWindow (GetCurrentWindow()))
;wn187="Desktop"
	if RealName == wnDesktop then
		Say (kcmsg071, ot_help) ;"This is the desktop list view"
		Say (kcmsg072, ot_help) ;"It contains shortcut icons"
		Say (kcmsg073, ot_help) ;"use the arrow keys to move from item to item"
		Say (kcmsg074, ot_help) ;"or press the first letter of the desired item"
		Say (kcmsg075, ot_help) ;"Press enter or double click to select"
		Say (kcmsg076, ot_help) ;"Press tab to move to the start button or shift + tab to move to the task bar"
		Say (kcmsg077, ot_help) ;"if the desktop items are not being read correctly"
		Say (kcmsg078, ot_help) ;"you may need to minimize all applications"
		Say (kcmsg079, ot_help) ;"this can be accomplished with insert plus f6"
		Return
	else
		Say (kcmsg080, ot_help) ;"This is a list view"
		Say (kcmsg081, ot_help) ;"use the arrow keys to read through the items"
		Say (kcmsg082, ot_help) ;"or press the first letter to jump to a desired item"
		Say (kcmsg083, ot_help) ;"items can be contained in one or more columns"
		Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
		Say (kcmsg085, ot_help) ;"hold down the shift key as you arrow up or down"
		Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
		Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
		Say (kcmsg088, ot_help) ;"and use control plus space bar"
		Say (kcmsg089, ot_help) ;" to select or unselect items"
		Say (kcmsg090, ot_help) ;"to here the items that have been selected"
		Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
		Say (kcmsg092, ot_help) ;"we recommend that you put files in a single column with all details"
		Say (kcmsg093, ot_help) ;"by selecting details from the view menu"
		Return
	EndIf
EndIf
;WT_TREEVIEW=31,
if (TheTypeCode == WT_TREEVIEW) then
	Say (kcmsg094, ot_help) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	Say (kcmsg095, ot_help) ;"use up or down arrow to read through the items"
	Say (kcmsg096, ot_help) ;"or press the first letter to jump through the list"
	Say (kcmsg097, ot_help) ;"use the right or left arrow keys to open or close an item or"
	Say (kcmsg098, ot_help) ;"use shift with the plus or minus key"
	Say (kcmsg099, ot_help) ;"to move to the prior level press backspace"
	Say (kcmsg100, ot_help) ;"to move to the root of the tree press home"
	Say (kcmsg101, ot_help) ;"to move to the last item on the tree press end"
	Return
EndIf
;WT_STARTBUTTON=32,
if (TheTypeCode == WT_STARTBUTTON) then
	Say (kcmsg102, ot_help) ;"This is the start button"
	Say (kcmsg103, ot_help) ;"Press Enter to open the start menu"
	Say (kcmsg104, ot_help) ;"items in the start menu are used to launch applications"
	Say (kcmsg105, ot_help) ;"or tab to move to the task bar"
	Say (kcmsg106, ot_help) ;"you can use control plus escape to activate this menu at any time"
	Return
EndIf
;WT_STARTMENU=33,
if (TheTypeCode == WT_STARTMENU) then
	Say (kcmsg107, ot_help) ;"This is the start menu"
	Say (kcmsg108, ot_help) ;"items in this menu are used to launch applications"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_CONTEXTMENU=34,
if (TheTypeCode == WT_CONTEXTMENU) then
	Say (kcmsg110, ot_help) ;"This is the context menu"
	Say (kcmsg109, ot_help) ;"Use up or down arrow to move between the items"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg040, ot_help) ;"Press Enter to select the current item"
	Return
EndIf
;WT_task bar=35
if (TheTypeCode == WT_TASKBAR) then
	Say (kcmsg111, ot_help) ;"This is the task bar"
	Say (kcmsg112, ot_help) ;" it contains the currently running applications"
	Say (kcmsg069, ot_help) ;"use the arrow keys to move between the tabs"
	Say (kcmsg113, ot_help) ;" use enter to invoke the application"
	Say (kcmsg114, ot_help)	 ;"use alt plus enter to open the task bar properties dialog"
	Say (kcmsg115, ot_help) ;"use the tab key to move to the desktop"
	Return
EndIf
;WT_MULTISELECT_LISTBOX=37,
if (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	Say (kcmsg116, ot_help) ;"This is a multiselect listbox"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg086, ot_help) ;"to select a non contiguous group of items"
	Say (kcmsg087, ot_help) ;"hold down the control key as you arrow up and down"
	Say (kcmsg118, ot_help) ;"and use the space bar to select the item"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
;WT_EXTENDEDSELECT_LISTBOX=38,
if (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	Say (kcmsg119, ot_help) ;"This is an extended select list box"
	Say (kcmsg084, ot_help) ;"to select a contiguous group of items"
	Say (kcmsg117, ot_help) ;"hold down the shift key as you arrow up and down"
	Say (kcmsg120, ot_help) ;"use shift + f8 to toggle the extended select option"
	Say (kcmsg121, ot_help) ;"When the extended select option is on"
	Say (kcmsg122, ot_help) ;"you can select multiple items with your space bar"
	Say (kcmsg090, ot_help) ;"to here the items that have been selected"
	Say (kcmsg091, ot_help) ;"use shift plus insert plus down arrow"
	Return
endif
if (TheTypeCode == WT_LEFTRIGHTSLIDER) then ;#39
	Say (kcmsg123, ot_help) ;"This is a horizontal slider"
	Say (kcmsg124, ot_help) ;"the value of the control increases as you move to the right"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
if (TheTypeCode == WT_UPDOWNSLIDER) then ;#40
	Say (kcmsg127, ot_help) ;"This is a vertical slider"
	Say (kcmsg128, ot_help) ;"the value of the control increases as you move upward"
	Say (kcmsg125, ot_help) ;"this type of control is frequently used to control settings such as"
	Say (kcmsg126, ot_help) ;"volume or pitch"
	Return
endif
;WT_EDITCOMBO = 41
if (TheTypeCode == WT_EDITCOMBO) then ;#41
	Say (kcmsg129, ot_help) ;"This is an edit Combo box"
	Say (kcmsg005, ot_help) ;"type in a value or use alt plus down arrow to open the list box"
	Say (kcmsg005b, ot_help); " use the arrow keys to move between the items"
	Say (kcmsg005c, ot_help); "use alt plus up arrow or Escape to close the list box"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Say (kcmsg150, ot_help) ;" previously selected items"
	Return
endif
;WT_PASSWORDEDIT=42,
if (TheTypeCode == WT_PASSWORDEDIT) then ;#42
	Say (kcmsg130, ot_help) ;"This is a password edit control"
	Say (kcmsg151, ot_help) ;" visually replaced by asteriks"
	Say (kcmsg131, ot_help) ;"Use the backspace to delete and start over"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
endif
if (TheTypeCode == WT_READONLYEDIT) then ;#43
		Say (schReadOnly1, ot_help)
		Say (schReadOnly2, ot_help)
;		Say (kcmsg132, ot_help) ;"This text is reed only"
;		Say (kcmsg133, ot_help) ;"you can navigate and read text with the jaws cursor"
;		Say (kcmsg134, ot_help) ;"but you cannot edit the text"
		Return
endif
if (theTypeCode == WT_COMMANDBAR) then ;#44
	Say (kcmsg136, ot_help);"This is a command bar"
	Say (kcmsg137, ot_help);"it consists of a row of buttons"
	Say (kcmsg138, ot_help) ;"you can arrow left or right to hear the different button names"
	Say (kcmsg139, ot_help) ;"and press enter to activate a button"
	Say (kcmsg140, ot_help) ;"press control plus tab to move to the next command bar"
	Say (kcmsg141, ot_help) ;"press escape to leave the command bar"
	return
endif
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	Say (kcmsg010, ot_help) ;"This is the menu bar"
	Say (kcmsg011, ot_help) ;"you can arrow left and right to hear the different menu names"
	Say (kcmsg012, ot_help) ;"Use Say Character to read the hot key"
	Say (kcmsg013, ot_help) ;"use the hotkey as a shortcut key or"
	Say (kcmsg014, ot_help) ;"press enter or down arrow to open a menu"
	Say (kcmsg015, ot_help) ;"press escape to exit the menu bar"
	return
endif
;if it gets this far it did not recognize the type code.
Say (kcmsg135, ot_help) ;"The Type Code is"
SayInteger (TheTypeCode)
ScreenSensitiveHelpForUnknownClasses (); catch everything not yet handled
EndFunction

; Functions designed to return information about the application environment
Int Function IsEditPreferencesDialog ()
; The window title of the edit preferences dialog changes to indicate the active dialog box 
; page name. Therefore, it would not be efficient to base the decision of whether or not the 
; active real window is the edit preferences dialog.  Since the only known window of 
; oscarui.jss is the edit preferences dialog, one could assume that the real window is the edit 
; preferences dialog simply because oscarui.dll is the active application.  However, the fact 
; that the edit preferences dialog is the only known window does not mean that it is the only 
; window.  Therefore, the window structure of the real window is used to confirm that the 
; window is the edit preferences dialog. 	The edit preferences dialog has the following unique 
; window structure:
;		The window class of the real window is #32770.
;		The first child window of the real window is #32770.
;		The next window after the first child window in the window hierarchy has a window class 
; 		of _Oscar_TabCtrl.
Var String rWinTitle, Handle rWin, String rWinClass, 
	Handle rWinFirstChild, Handle hTarget, String hTargetClass
Let rWin = GetRealWindow (GetFocus())
Let rWinClass = GetWindowClass (rWin)
Let rWinTitle = GetWindowName (rWin)
Let rWinFirstChild = GetFirstChild (rWin)
Let hTarget = GetNextWindow (rWinFirstChild)
Let hTargetClass = GetWindowClass (hTarget)
If (rWinClass == wcDialog && hTargetClass == wcOscarTabControl) then
	Return 1
Else
	Return 0
EndIf
EndFunction

String Function GetActivePageName ()
Var String strPageName
;	The window title of the edit preferences dialog changes to indicate the active dialog box 
; page name. Therefore, all that is necessary to get the active page name is to confirm that 
; the active real window is the Edit Preferences dialog box by using IsEditPreferencesDialog () 
; and returning the real window title.	If the edit preferences dialog is not the active real 
; window, a null string is returned.
If (IsEditPreferencesDialog ()) then
	Let strPageName = GetWindowName (GetRealWindow (GetFocus ()))
Else
	Let strPageName = strNull
EndIf
Return strPageName
EndFunction

Handle Function GetAwayPageToolbar ()
; This function is used to get the window handle of the tool bar found on the away page of the 
; edit	preferences dialog box.
Var Handle rWin, String rWinTitle, Handle hTarget, Handle hTemp, Int nCount
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, AwayPage) == 0) then
	Say (msgOnlyAway, ot_message)
	Return 0
Else
	;  Get the window handle of the Away page.  It is the twelth child window of the real window
	Let hTemp = GetFirstChild (rWin)
	Let nCount = 0
	While (GetWindowName (hTemp) != AwayPage && hTemp != 0)
		Let hTemp = GetNextWindow (hTemp)
	EndWhile
	Let hTarget = FindDescendantWindow (hTemp, cID_AwayPageToolBar)
	If (!hTarget) then
		Say (msgCNFToolBar, ot_status)
	EndIf
EndIf
Return hTarget
EndFunction

HANDLE Function GetNewAwayMessageToolBar (handle rWin)
Var
	Handle hTemp, Handle hTarget
If (GetWindowName (rWin) == wnNewAwayMessage) then
	Let hTemp = FindDescendantWindow (rWin, cID_NAMToolParent)
	Let hTarget = FindDescendantWindow (rWin, cID_NAMTool)
	Return hTarget
Else
	Return 0
EndIf
EndFunction

String Function GetButtonList (handle hToolBar)
Var 
	String strButtonName, String strButtonList
Let strButtonList = ""
If (IsWindowVisible (hToolBar) == TRUE) then
	SaveCursor ()
	InvisibleCursor ()
;	MoveToWindow (hToolBar)
	MoveTo (GetWindowLeft (hToolBar), GetWindowTop (hToolBar))
	While (GetWindowClass (GetCurrentWindow ()) == wcCBClass && FindNextAttribute (ATTRIB_GRAPHIC))
		Let strButtonName = GetWord ()
		If (strButtonName != "corner") then
				Let strButtonList = strButtonList + strButtonName + "\007"
		EndIf
	EndWhile
	RestoreCursor ()
	Return strButtonList
Else
	Return ""
EndIf
EndFunction

Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
If (FindGraphic (winHandle, buttonLabel, s_top, s_restricted)) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgToolNotFound, ot_control_name)
EndIf
RestoreCursor ()
EndFunction

Void Function ResetnSuppressEcho ()
Let nSuppressEcho = FALSE
EndFunction

;  Event functions and functions that are only called by event functions
Int Function SayCustomControls (handle curWin, int curID, string strPage)
Var String strTemp, Handle hTemp, Int nCount
;SayInteger (curID)
If (StringContains (strPage, BuddyChatPage)) then
; The two edit combo boxes in the sounds group of the buddy chat page of the edit 
; preferences dialog box both have a control ID of 1001.  JFW fails to say anything other than 
; combo box when either of them gains focus.  Both edit combo boxes are associated with a 
; check box.  In both cases the check box is located one window prior to the parent window of
; the edit combo box.  In order to make JFW speak the control properly, say the control group 
; the combo edit box belongs to	(Sounds), then get the window handle of the window prior to 
; the parent window of the current control and use SayWindow (...) to say the text of the 
; window.  Then say the control type and if there is any highlighted text in the control, say it.
	If (curID == cID_SoundWhenRecieveComboBox) then
		Say (cgSounds, ot_message)
		Let hTemp = GetParent (curWin)
		Let hTemp = GetPriorWindow (hTemp)
		SayWindow (hTemp, READ_EVERYTHING)
		Say (msgEditCombo, ot_message)
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return 1
;	JFW reports that the two check boxes that are part of the sounds group are part of the Chat 
;	window group.  To resolve this Say the actual group name, then say the text of the current 
;	window using SayWindow (...).  Next say the control type and state.
	ElIf (curID == cID_SoundWhenRecieveCheckBox || curID == cID_SoundWhenSendingCheckBox) then
		Say (cgSounds, ot_message)
		SayWindow (curWin, ot_message)
;		Say (GetObjectType (), ot_message)
;		Say (GetObjectState (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_control_name)
		If (ControlIsChecked ()) then
			Say (msgChecked, ot_message)
		Else
			Say (msgUnChecked, ot_message)
		EndIf
		Return 1
;	The two check boxes in the sounds group each have a browse and a preview button 
; associated whith them.  By default JFW does not report which check box they are associated 
; with.  JFW does not even correctly report the control group they belong to.  To resolve this 
; say the actual group name (sounds).  Then walk back through the window hierarchy until 
; finding the last previous window of window type WT_CHECKBOX.  Then say the contents of 
; the window found.  Next say the control name and type.
	ElIf ((curID == cID_SoundWhenRecieveBrowse)
		|| (curID == cID_SoundWhenRecievePreview)
		|| (curID == cID_SoundWhenSendingBrowse)
		|| (curID == cID_SoundWhenSendingPreview)) then
		Say (cgSounds, ot_message)
		Let hTemp = curWin
		While (GetWindowSubtypeCode (hTemp) != WT_CHECKBOX && hTemp != 0)
			Let hTemp = GetPriorWindow (hTemp)
		EndWhile
		SayWindow (hTemp, READ_EVERYTHING)
		Say (GetWindowName (GetCurrentWindow ()), ot_message)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		Return 1
	EndIf
;	The sounds page of the edit preferences dialog has the following check boxes divided into 
;	two groups, Buddy Sounds and IM Sounds:
;	1.		Play a sound when buddies sign on
;	2.		Play a sound when buddies sign off
;	3.		Play a sound when first message is received
;	4.		Play a sound when receiving a message
;	5.		Play a sound when sending a message.
;	Each check box has three other controls that are associated with it; a sound name combo 
;	box, a browse button and a preview button.  When the user is navigating through the sound 
;	page of the dialog box, announce the current group and the associated check box for each 
; control
ElIf (strPage == SoundsPage) then
	If (curID == cID_SoundName) then
		SaveCursor ()
		InvisibleCursor ()
;		JAWSCursor ()
		MoveTo (GetWindowLeft (curWin), GetWindowTop (curWin))
		PriorLine ()
		Let strTemp = GetWord ()
		If (strTemp != strPlay) then
			PriorLine ()
		EndIf
		Let strTemp = GetChunk ()		
		RestoreCursor ()
		If (strTemp == wnWhenBuddiesSignOn || strTemp == wnWhenBuddiesSignOff) then
			Say (cgBuddySounds, ot_message)
		Else
			Say (cgIMSounds, ot_message)
		EndIf
		Say (strTemp, ot_message)
		Say (wnSoundName, ot_message)
		SayWindowTypeAndText (curWin)
		return 1
	ElIf (curID == cID_WhenBuddiesSignOnBrowse || curID == cID_WhenBuddiesSignOnPreview) then
		Say (cgBuddySounds, ot_message)
		Say (wnWhenBuddiesSignOn, ot_message)
		Say (GetWindowName (curWin), ot_message)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		return 1
	ElIf (curID == cID_WhenBuddiesSignOffBrowse || curID == cID_WhenBuddiesSignOffPreview) then
		Say (cgBuddySounds, ot_message)
		Say (wnWhenBuddiesSignOff, ot_message)
		Say (GetWindowName (curWin), ot_message)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		return 1
	ElIf (curID == cID_WhenFirstMessageRecievedBrowse || curID == cID_WhenFirstMessageRecievedPreview) then
		Say (cgIMSounds, ot_message)
		Say (wnWhenFirstMessageRecieved, ot_message)
		Say (GetWindowName (curWin), ot_message)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		return 1
	ElIf (curID == cID_WhenRecievingBrowse || curID == cID_WhenRecievingPreview) then
		Say (cgIMSounds, ot_message)
		Say (wnWhenRecieving, ot_message)
		Say (GetWindowName (curWin), ot_message)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		return 1
	ElIf (curID == cID_WhenSendingBrowse|| curID == cID_WhenSendingPreview) then
		Say (cgIMSounds, ot_message)
		Say (wnWhenSending, ot_message)
		Say (GetWindowName (curWin), ot_message)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		return 1
	Else
		return 0
	EndIf
;  The general page of the edit preferences dialog box has one control that JFW does not read 
; properly. This is a check box that allows the user to decide whether or not to sho an accept 
; messages dialog box when a buddy sends them a message.  Because of space constraints 
; and the length of the label, only part of the label could be included as part of the check box.  
; The remainder of the check box's label was placed in a static window that is next in the 
; window hierarchy.  In order to cause JFW to speak the entire label, say the name of the 
; current control group, then say the text of the current window.  Next get the window handle 
; of the next window in the window hierarchy and say the text of the window.  Finally say the 
; control type and state.
ElIf (strPage == GeneralPage) then
	If (curID == cID_ShowAcceptMessage) then
		Say (cgIM, ot_message)
		SayWindow (curWin, READ_EVERYTHING)
		Let hTemp = GetNextWindow (curWin)
		SayWindow (hTemp, READ_EVERYTHING)
;		Say (GetObjectType (), ot_message)
;		Say (GetObjectState (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		If (ControlIsChecked ()) then
			Say (msgChecked, ot_message)
		Else
			Say (msgUnChecked, ot_message)
		EndIf
		Return 1
	Else
		Return 0
	EndIf
; The connection page of the edit preferences dialog box has four edit boxes that JFW does 
; not speak correctly.
;	They are as follows:
;	1.		In the Proxy Server Group
;		a.	Host:
;		b.	Port:
;	2.		In the Authentication Group
;		a.	Username
;		b.	Password
;	In each of these edit boxes, JFW says the control group name rather than the actual label.
ElIf (strPage == ConnectionPage) then
; The Host: and the Port: edit boxes both have a control ID of 346.
; The Username: and the Password: edit boxes both have a control ID of 355:
;	If the current control ID is either one of these
	If (curID == cID_Host || curID == cID_Username) then
		;	All four edit boxes are a part of the Connect Using Proxy grandfather group
		Say (wnConnectProxy, ot_message)
		;	Say the appropriate group name
		If (curID == cID_Host) then
			Say (cgProxyServer, ot_message)
		ElIf (curID == cID_UserName) then
			Say (cgAuthentication, ot_message)
		EndIf
		;	Get the chunk of text immediatly prior to the field and say it.  This is the actual field label.
		SaveCursor ()
		InvisibleCursor ()
		MoveTo (GetWindowLeft (curWin), GetWindowBottom (curWin) - 3)
		PriorChunk ()
		Let strTemp = GetChunk ()
		Say (strTemp, ot_message)
		RestoreCursor ()
		; Say that it is an edit box
		Say (msgEdit, ot_message)
		;	If the control contains highlighted text, say it
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return 1
	Else
		Return 0
	EndIf
; In the controls page of the edit preferences dialog, there are 6 controls that JFW does not 
; speak
ElIf (strPage == ControlsPage) then
; Allow List list box, JFW reports as "Who Can Contact Me ..."
	If (curID == cID_AllowList) then
		;	Say the group it belongs in
		Say (cgWhoCanContactMe, ot_message)
		;	Say the name of the control
		Say (wnAllow, ot_message)
		; Say the control type
		Say (msgUserList, ot_message)
		; If the control contains highlighted text, say it.
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return 1
; Block List list box, JFW reports as "Who Can Contact Me ..."
	ElIf (curID == cID_BlockList) then
		;	Say the group it belongs in
		Say (cgWhoCanContactMe, ot_message)
		;	Say the name of the control
		Say (wnBlock, ot_message)
		; Say the control type
		Say (msgUserList, ot_message)
		; If the control contains highlighted text, say it.
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return 1
; The Add and remove buttons that correspond to the Block List List box, JFW reports as 
; "Who can contact me ... Button." The Add and remove buttons that correspond to the Allow 
; List List box, JFW reports as "Who can contact me ... Button."
	ElIf ((curID == cID_AllowAdd)
		|| (curID == cID_AllowRemove)
		|| (curID == cID_BlockAdd)
		|| (curID == cID_BlockRemove)) then
		; Say the grandparent group
		Say (cgWhoCanContactMe, ot_message)
		;	Say whether the button belongs to the Allow List or the Block List
		If ((curID == cID_AllowAdd) || (curID == cID_AllowRemove)) then
			Say (wnAllow, ot_message)
		ElIf ((curID == cID_BlockAdd)|| (curID == cID_BlockRemove)) then
			Say (wnBlock, ot_message)
		EndIf
		;	Say the control name
		Say (GetWindowName (GetCurrentWindow ()), ot_message)
		;	Say the control type
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		Return 1
	EndIf
;	There are two controls on the buddy page that do not read correctly.
;	One is the Dim buddies after they have been idle for check box, the other is the edit box that 
; follows the Dim buddies after they have been idle for check box that specifies the number of 
; minutes. In the Dim buddies after they have been idle for check box, the number of minutes 
; edit box is the next window and the next window after that has the label for the minutes edit 
; box.  In order to allow the user to hear the entire 	sentence, Say the window text along with 
; the window text of the next two windows in the window hierarchy. In the minutes edit box, 
; Say the prior window, say the phrase wait for, say the next window
ElIf (strPage == BuddyPage) then
	If (curID == cID_DimAfter) then
		SayWindow (curWin, READ_EVERYTHING)
		Let hTemp = GetNextWindow (curWin)
		SayWindow (hTemp, READ_EVERYTHING)
		Let hTemp = GetNextWindow (hTemp)
		SayWindow (hTemp, READ_EVERYTHING)
;		Say (GetObjectType (), ot_message)
;		Say (GetObjectState (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		If (ControlIsChecked ()) then
			Say (msgChecked, ot_message)
		Else
			Say (msgUnchecked, ot_message)
		EndIf
		Return 1
	ElIf (curID == cID_Minutes) then
		Let hTemp = GetPriorWindow (curWin)
		SayWindow (hTemp, READ_EVERYTHING)
		Say (msgWaitFor, ot_message)
		Let hTemp = GetNextWindow (curWin)
		SayWindow (hTemp, READ_EVERYTHING)
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		Return 1
	EndIf 
ElIf (strPage == FileTransferPage) then
; The combo box that goes along with the Allow only users in Buddy group: check box
;	is by default spoken as the When others issue the file get command combo box.
;	In order to speak it correctly, announce that it belongs to the When others issue the file 
;	get command control group, then get the chunk of text immediately before the combo box
; 	and speak it (the chunk of text immediately before the combo box is the label for the 
;	Allow only users in Buddy group: check box.  Then say the control type and if the 
; 	combo box contains highlighted text, speak the text.
	If (curID == cID_WhoCanGetFilesComboBox) then
		Say (cgWhenFileGet, ot_message)
		SaveCursor ()
		InvisibleCursor ()
		MoveTo (GetWindowLeft (curWin), GetWindowBottom (curWin) - 3)
		PriorChunk ()
		Let strTemp = GetChunk ()
		Say (strTemp, ot_message)
		RestoreCursor ()
;		Say (GetObjectType (), ot_message)
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			SayChunk ()
		EndIf
		Return 1
;	The edit boxes "Directory from where others can get my files or I send files:" and
;	"Directory to put files I receive:" both have a brows button associated with them.
;	JFW does not normally report which of the edit boxes the browse button is associated with.
;	In both cases, this can be done by saying the text of the window that is located two windows 
; prior to the button in the window hierarchy.  Then say the object name and type.
	ElIf ((curID == cID_BrowseForGetDir) 
		|| (curID == cID_BrowseForRecieveDir)) then
		Let hTemp = curWin
		Let nCount = 0
		While (nCount < 2)
			Let hTemp = GetPriorWindow (hTemp)
			Let nCount = nCount + 1
		EndWhile
		SayWindow (hTemp, READ_EVERYTHING)
;		Say (GetObjectName (), ot_message)
;		Say (GetObjectType (), ot_message)
		GetWindowName (GetCurrentWindow ())
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		Return 1
;	The six radial buttons that make up the radial button groups To Buddy and From Buddy do 
; not announce the group to which they belong.   In order to correct this, Say Initial transfer 
; speed (because these two radial button groups are in turn part of the Initial Transfer Speed 
; group), say the group name to which they belong, say the control name, say the control type,
; 	say the control status, and then say which radial button of the group it is.
	ElIf ((curID == cID_ToBuddyFast) 
		|| (curID == cID_ToBuddyMedium)
		|| (curID == cID_ToBuddySlow)
		|| (curID == cID_FromBuddyFast)
		|| (curID == cID_FromBuddyMedium)
		|| (curID == cID_FromBuddySlow)) then
		Say (cgInitSpeed, ot_message)
		If ((curID == cID_ToBuddyFast) 
			|| (curID == cID_ToBuddyMedium)
			|| (curID == cID_ToBuddySlow)) then
			Say (cgToBuddy, ot_message)
		ElIf ((curID == cID_FromBuddyFast)
			|| (curID == cID_FromBuddyMedium)
			|| (curID == cID_FromBuddySlow)) then
			Say (cgFromBuddy, ot_message)
		EndIf
;		Say (GetObjectName (), ot_message)
;		Say (GetObjectType (), ot_message)
;		Say (GetObjectState (), ot_message)
		GetWindowName (GetCurrentWindow ())
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		If (ControlIsChecked ()) then
			Say (msgChecked, ot_message)
		Else
			Say (msgUnChecked, ot_message)
		EndIf
		If (curID == cID_ToBuddyFast) then
			Say (msg1of3, ot_message)
		ElIf (curID == cID_ToBuddyMedium) then
			Say (msg2of3, ot_message)
		ElIf (curID == cID_ToBuddySlow) then
			Say (msg3of3, ot_message)
		ElIf (curID == cID_FromBuddyFast) then
			Say (msg1of3, ot_message)
		ElIf (curID == cID_FromBuddyMedium) then
			Say (msg2of3, ot_message)
		ElIf (curID == cID_FromBuddySlow) then
			Say (msg3of3, ot_message)
		EndIf
		Return 1
	EndIf
ElIf (strPage == VirusCheckerPage) then
;	On the Virus Checker page of the Edit Preferences Dialog, JFW reports the Virus Checker 
; Location Browse Button as the Virus Checker browse button.  In order to cause JFW to read 
; this control correctly, Say the control group name, say the window text of the window 
; immediately before it in the window hierarchy and then say the object name and type.
	If (curID == cID_VirusCheckerBrowse) then
		Say (cgVirusChecker, ot_message)
		Let hTemp = GetPriorWindow (curWin)
		SayWindow (hTemp, READ_EVERYTHING)
		Say (GetObjectName (), ot_message)
;		Say (GetObjectType (), ot_message)
;		GetWindowName (GetCurrentWindow ())
		Say (GetWindowType (GetCurrentWindow ()), ot_message)
		Return 1
	EndIf
ElIf (strPage == AwayPage) then
; On the away page of the edit preferences dialog, the when idle message edit box does not 
; have a label. Therefore, when focus moves into the field, JFW says nothing.  Resolve this by 
; having JFW say When Idle Message followed by the control type.
	If (curID == cID_WhenIdleMessage) then
		Say (cgWhenIdle + msgSpace + msgMessage, ot_message)
		Say (msgEdit, ot_message)
		Return 1
; On the away page of the edit preferences dialog, the label of the Labels For Menu list box is 
; not spoken.  Instead, JFW speaks only the control group name followed by the control type.  
; Resolve this by reading the text of the prior window (which is the label for the list box), after 
; saying the control group name.
	ElIf (curID == cID_LabelsForMenu
		&& GetWindowClass (curWin) == wcListBox) then
		Say (cgAwayMessages, ot_control_name)
		SayWindow (GetPriorWindow (curWin), READ_EVERYTHING)
		Say (GetWindowType (curWin), ot_control_name)
		Return 1
	EndIf
return 0
EndIf
Return 0
EndFunction

Void Function SayFocusedWindow ()
Var String rWinTitle, Handle rWin,
	Int nID, Handle curWin
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWin = GetCurrentWindow ()
Let nID = GetCurrentControlID ()
; Control speaking of edit preferences dialog box
If (IsEditPreferencesDialog ()) then
	; Check for a change in window title
	If (StringContains (rWinTitle, GlobalPrevRealName) == FALSE) then
		; FocusChangedEvent (...) (and thus SayFocusedWindow ()) is not called when the 
		; user presses Control + Tab or Shift + Control + Tab to move between the dialog 
		; box pages.  Therefore, without some preventative measures the current dialog 
		; box page will be spoken the first time the user presses tab after switching between 
		; pages.  This is prevented by two global variables, NextDocumentWindowCalled and 
		; PreviousDocumentWindowCalled.  Their function is as follows:
		;	1.  AutoStartEvent, initialized to zero in order to enable speaking of dialog when 
		;			switching between applications
		;	2.  NextDocument and PreviousDocumentWindow, the appropriate variable is set to one
		;	3.	  SayFocusedWindow, if either variable is not equal to 0, only 
		;			SayWindowTypeAndText (GlobalFocusWindow) is called to speak the active control
		;			and both variables are set back to 0.  Otherwise, the dialog information is spoken
		If (NextDocumentWindowCalled == 0
			&& PreviousDocumentWindowCalled == 0
			&& nAppChanged == 0) then
			; Say Edit Preferences Dialog
			Say (msgDialogName, ot_message)
			; Say the active page name
			Say (GetActivePageName () + strSpace + msgPage, ot_message)
			; Say the active control
			If (SayCustomControls (curWin, nID, rWinTitle) == 0) then
				SayWindowTypeAndText (GlobalFocusWindow)
			EndIf
			Return
		Else
			Let nAppChanged = 0
			Let NextDocumentWindowCalled = 0
			Let PreviousDocumentWindowCalled = 0
			If (SayCustomControls (curWin, nID, rWinTitle) == 0) then
				SayWindowTypeAndText (GlobalFocusWindow)
			EndIf
			Return
		EndIf
	Else
		If (SayCustomControls (curWin, nID, rWinTitle) == 0) then
;			SayWindowTypeAndText (GlobalFocusWindow)
			SayWindowTypeAndText (GetCurrentWindow ())
		EndIf
	EndIf
Else
	If (StringContains (rWinTitle, wnNewAwayMessage) 
		&& GetWindowClass (curWin) == wcAte32) then
			Say (wnEnterNewAwayMessage + " " + wcEdit, ot_message)
			Return
	Else
		SayWindowTypeAndText (GlobalFocusWindow)
	EndIf
EndIf
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var handle RealWindow, string RealWindowName, handle AppWindow
If (nSuppressEcho == TRUE) then 
	Return 
EndIf
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow && AppWindow != FocusWindow) then
	; we've switched to a different app main window,
	; and it does not have the focus, so announce it
	; Calling here SayWindowTypeAndText (AppWindow) in the Edit Preferences dialog box
	; causes it to be misread.  Do nothing here in the edit preferences dialog
	If (IsEditPreferencesDialog ()) then
	Else
		SayWindowTypeAndText (AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
  || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
  If ((RealWindow != AppWindow) && (RealWindow != FocusWindow)) then
	; Calling here SayWindowTypeAndText (RealWindow) in the Edit Preferences dialog box
	; causes it to be misread.  Do nothing here in the edit preferences dialog
		If (IsEditPreferencesDialog ()) then
		Else
			SayWindowTypeAndText (RealWindow)
		EndIf
  endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
Var String rWinTitle, String hwndClass
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
Let hwndClass = GetWindowClass (hwnd)
If (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectItemDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectScriptDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (hwndClass == wcSysTabControl) then
	If (numTimes == 0) then
		Say (buffer, ot_buffer)
		Let numTimes = 1
	ElIf (numTimes != 0) then
		Return
	EndIf
Else
	SayHighLightedText (hwnd, buffer)
EndIf
EndFunction

Void Function AutoStartEvent ()
Let NextDocumentWindowCalled = 0
Let PreviousDocumentWindowCalled = 0
Let numTimes = 0
Let nSuppressEcho = 0
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
If (nSuppressEcho == TRUE) then 
	Return 
Else
	NewTextEvent (hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)
EndIf
EndFunction

; Scripts used in Oscarui.dll
Script NextDocumentWindow()
{control+tab}
delay (1)
If (IsEditPreferencesDialog ()) then
	Say (GetActivePageName () + " " + msgPage, ot_message)
	Let NextDocumentWindowCalled = 1
EndIf	
EndScript

Script PreviousDocumentWindow()
{Shift + control+tab}
delay (1)
If (IsEditPreferencesDialog ()) then
	Say (GetActivePageName () + " " + msgPage, ot_message)
	Let PreviousDocumentWindowCalled = 1
EndIf	
EndScript

Script  ScriptFileName()
ScriptAndAppNames(msgOscaruiScriptFile) ;msgOscaruiScriptFile = "AOL Instant Messenger Edit Preferences",
EndScript

Script SelectATool ()
Var String rWinTitle, handle winHandle, int nItem, 
	String strButtonList, String strSelectedTool, Handle rWin
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, AwayPage)
	&& IsEditPreferencesDialog ()) then
	If (GetCurrentControlID () != cID_WhenIdleMessage) then
		Say (msgWhenIdleMessageOnly, ot_message)
		Return
	EndIf
	let winHandle = GetAwayPageToolbar ()
	if (!winHandle || !IsWindowVisible (winHandle)) then
		return
	EndIf
	Let strButtonList = GetButtonList (winHandle)
	let nItem = dlgSelectItemInList (strButtonList, AwayPageToolbarDialogName, FALSE)
	If (nItem !=0) then
		Let strSelectedTool = StringSegment (strButtonList, "\007", nItem)
		let nSuppressEcho = TRUE
		delay (2)
		ClickToolBarButton (winHandle, strSelectedTool)
	EndIf
	ScheduleFunction ("ResetnSuppressEcho", 2)
ElIf (rWinTitle == wnNewAwayMessage) then
	Let strButtonList = ""
	Let winHandle = GetNewAwayMessageToolBar (rWin)
	Let strButtonList = GetButtonList (winHandle)
	If (strButtonList != "") then
		let nItem = dlgSelectItemInList (strButtonList, AwayPageToolbarDialogName, FALSE)
		If (nItem !=0) then
			Let strSelectedTool = StringSegment (strButtonList, "\007", nItem)
			let nSuppressEcho = TRUE
			delay (2)
			ClickToolBarButton (winHandle, strSelectedTool)
			ScheduleFunction ("ResetnSuppressEcho", 1)
		EndIf
	EndIf
Else
	Say (msgOnlyAway, ot_message)
EndIf
EndScript

Script ScreenSensitiveHelp ()
var handle WinHandle, int TheTypeCode, String TheClass,
	String rWinTitle, Handle rWin, String strTemp, Int curID
;if (IsSameScript ()) then
;	AppFileTopic()
;	return
;EndIf
if (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp()
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
let TheTypeCode = GetWindowSubTypeCode (WinHandle)
let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curID = GetCurrentControlID ()
If (IsEditPreferencesDialog ()) then
	If (rWinTitle == ControlsPage) then
		If (curID == cID_AllowList) then
			Say (shmsg_ThisIsThe + msgSpace + wnAllow + msgSpace + msgUserList, ot_help)
			Say (shmsg_LikeListBox, ot_help)
			Say (shmsg_ItContainsUserList + msgSpace + wnAllow, ot_help)
			Say (shmsg_ToAddUserList + msgSpace + wnAllow + msgSpace + msgAddButton, ot_help)
			Say (shmsg_ToRemoveUserList + msgSpace + wnAllow + msgSpace + msgRemoveButton, ot_help)
			Return
		ElIf (curID == cID_BlockList) then
			Say (shmsg_ThisIsThe + msgSpace + wnBlock + msgSpace + msgUserList, ot_help)
			Say (shmsg_LikeListBox, ot_help)
			Say (shmsg_ItContainsUserList + msgSpace + wnBlock, ot_help)
			Say (shmsg_ToAddUserList + msgSpace + wnBlock + msgSpace + msgAddButton, ot_help)
			Say (shmsg_ToRemoveUserList + msgSpace + wnBlock + msgSpace + msgRemoveButton, ot_help)
			Return
		EndIf
	ElIf (rWinTitle == BuddyPage) then
		If (curID == cID_BuddyListFont) then
			Say (shmsg_BuddyListFont + " " + shmsg_BuddyListFontA, ot_help)
			Say (kcmsg003, ot_help)
			Return
		EndIf
	ElIf (rWinTitle == AwayPage) then
		If (curID == cID_WhenIdleMessage) then
			Say (shmsg_ThisIsThe + cgWhenIdle + " " + msgMessage + " " + msgEditBox, ot_help)
			Say (shmsg_press + " " + GetScriptKeyName ("SelectATool") + " " + shmsg_Toolbar, ot_help)
			Say (shmsg_idleMsg, ot_help)
			Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
			Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
			Return
		EndIf
	EndIf
EndIf
PerformScript ScreenSensitiveHelp()
EndScript


Void Function HotKeyLoop ()
Var Handle rWin, Handle hFirstChild, Handle hPage, Handle hTemp, Int nTypeCode, 
Int FoundHotKey, String strHelpPhrase, String strType
Let FoundHotKey = 0
Let strHelpPhrase = ""
Let rWin = GetRealWindow (GetFocus ())
Let hFirstChild = GetFirstChild (rWin)
Let hPage = hFirstChild
While (StringContains (GetWindowName (hPage),  GetActivePageName ()) == FALSE && hPage)
	Let hPage = GetNextWindow (hPage)
EndWhile
Let hTemp = GetFirstChild (hPage)
SaveCursor ()
InvisibleCursor ()
While (hTemp)
	let nTypeCode = GetWindowTypeCode (hTemp)
	If ((nTypeCode == WT_BUTTON) ||
		(nTypeCode == WT_STATIC) ||
		(nTypeCode == WT_RADIOBUTTON) ||
		(nTypeCode == WT_CHECKBOX) ||
		(nTypeCode == WT_GROUPBOX) ||
		(nTypeCode == WT_3STATE) ||
		(nTypeCode == WT_TABCONTROL)) then
		MoveToWindow (hTemp)
		;strNull=""
		if (GetHotKey() != strNull) then
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				Say (hkmsgHotKeysAre, ot_help)	;"Hot keys are as follows:"
			EndIf
			;wn289=" use alt  "
;			Let HelpPhrase = GetChunk () + wn289 + GetHotKey()
			If (nTypeCode == WT_BUTTON) then
				Let strType = TypeButton
			ElIf (nTypeCode == WT_STATIC) then
				Let strType = TypeStatic
			ElIf (nTypeCode == WT_RADIOBUTTON) then
				Let strType = TypeRadioButton
			ElIf	(nTypeCode == WT_CHECKBOX) then
				Let strType = TypeCheckBox
			ElIf (nTypeCode == WT_GROUPBOX) then
				Let strType = TypeGroupBox
			ElIf (nTypeCode == WT_TABCONTROL) then
				Let strType = TypeTabControl
			EndIf
;			Let strHelpPhrase = hkmsgForThe + strSpace + GetObjectName () + strSpace + strType + strSpace + hkmsgAltPlus + strSpace + GetHotKey ()
			Let strHelpPhrase = hkmsgForThe + strSpace + GetWindowName (GetCurrentWindow ()) + strSpace + strType + strSpace + hkmsgAltPlus + strSpace + GetHotKey ()
				Say (strHelpPhrase, ot_help)
				let FoundHotKey = 1
		EndIf
	EndIf ; condition for static text or button
	Let hTemp = GetNextWindow (hTemp)
EndWhile
RestoreCursor ()
If (FoundHotKey == 0) then
	If (IsEditPreferencesDialog ()) then
		Say (hkmsgNoHotKeys, ot_help)
	ElIf (DialogActive ()) then ;only say this string if in a dialog
		;"unable to determine hot keys in this dialog"
		Say (hkmsgUnable, ot_help)
	EndIf
EndIf
EndFunction

Script HotKeyHelp ()
Var String strPage
If (IsEditPreferencesDialog ()) then
;	Let strPage = GetActivePageName ()
;	If (strPage == SoundsPage) then
;		Say (hkmsgNoHotKeys, ot_help)
;	EndIf
;	Return
	HotKeyLoop ()
	Return
EndIf
PerformScript HotKeyHelp()
EndScript

Script SayTextForSelectedLabel ()
Var 
	Handle curWin, String curWinClass, Int curID, 
	Handle hTemp, Handle hTarget
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curID = GetCurrentControlID ()
If (IsEditPreferencesDialog ()
	&& GetActivePageName () == AwayPage) then
	If (curID == cID_LabelsForMenu 
		&& curWinClass == wcListBox) then
		If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			Let hTemp = GetNextWindow (curWin)
			Let hTarget = GetNextWindow (hTemp)
			SayWindow (hTarget, READ_EVERYTHING)
		Else
			Say (msgNoSelItem, ot_message)
		EndIf
	Else
		Return
	EndIf
Else
	Return
EndIf
EndScript

Script  SayWindowPromptAndText()
;SayWindowTypeAndText(GetCurrentWindow())
SayFocusedWindow ()
EndScript